/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "pin_mux.h"
#include "board.h"
#include "sl_protocol.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define APP1_ENABLE    1
#if APP1_ENABLE
#define BOARD_LED_PORT BOARD_LED_BLUE_GPIO_PORT
#define BOARD_LED_PIN  BOARD_LED_BLUE_GPIO_PIN
#else
#define BOARD_LED_PORT BOARD_LED_RED_PORT
#define BOARD_LED_PIN  BOARD_LED_RED_PIN
#endif

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
volatile uint32_t g_systickCounter;
extern SL_PINSETUP_T PINONLYCFGTABLEFLASH;

/*******************************************************************************
 * Code
 ******************************************************************************/
void SysTick_Handler(void)
{
    if (g_systickCounter != 0U)
    {
        g_systickCounter--;
    }
}

void SysTick_DelayTicks(uint32_t n)
{
    g_systickCounter = n;
    while (g_systickCounter != 0U)
    {
    }
}

/*!
 * @brief Main function
 */
int main(void)
{
    /* Init output LED GPIO. */
    GPIO_PortInit(GPIO, 0);
	GPIO_PortInit(GPIO, 1);
    /* Board pin init */
    BOARD_InitBootPins();
    BOARD_BootClockFRO48M();
	
	SL_PINSETUP_T *psetup = (SL_PINSETUP_T*)&PINONLYCFGTABLEFLASH; 

    /* Set systick reload value to generate 1ms interrupt */
    if (SysTick_Config(SystemCoreClock / 1000U))
    {
        while (1)
        {
        }
    }
	
	/* jump to the secondary bootloader */
	//bootSecondaryLoader(psetup);	

    while (1)
    {
        /* Delay 1000 ms */
        SysTick_DelayTicks(1000U);
        GPIO_PortToggle(GPIO, BOARD_LED_PORT, 1u << BOARD_LED_PIN);
    }
}
